<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}


$providerUrls = [
    "pragmatic"   => "https://main.intergacor88-samuk.com/slots/pragmatic-play",
    "pgsoft"      => "https://main.intergacor88-samuk.com/slots/pgsoft",
    "joker"       => "https://main.intergacor88-samuk.com/slots/joker-gaming",
    "spadegaming" => "https://main.intergacor88-samuk.com/slots/spadegaming",
    "habanero"    => "https://main.intergacor88-samuk.com/slots/habanero",
    "cq9"         => "https://main.intergacor88-samuk.com/slots/cq9",
    "playtech"    => "https://main.intergacor88-samuk.com/slots/playtech",
    "microgaming" => "https://main.intergacor88-samuk.com/slots/microgaming",
    "netent"      => "https://main.intergacor88-samuk.com/slots/netent",
    "yggdrasil"   => "https://main.intergacor88-samuk.com/slots/ygg",
    "redtiger"    => "https://main.intergacor88-samuk.com/slots/redtiger",
    "nolimitcity" => "https://main.intergacor88-samuk.com/slots/nolimitcity"
];

$providerFiles = [
    "pragmatic"   => "games_pragmatic.json",
    "pgsoft"      => "games_pgsoft.json",
    "joker"       => "games_joker.json",
    "spadegaming" => "games_spadegaming.json",
    "habanero"    => "games_habanero.json",
    "cq9"         => "games_CQ9.json",        
    "playtech"    => "games_playtech.json",
    "microgaming" => "games_microgaming.json",
    "netent"      => "games_netent.json",
    "yggdrasil"   => "games_yggdrasil.json",
    "redtiger"    => "games_redtiger.json",
    "nolimitcity" => "games_nolimitcity.json" 
];


$provider = strtolower($_GET['provider'] ?? "");
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
  <meta charset="UTF-8">
  <title>Import Games</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = { darkMode: 'class' }
  </script>
</head>
<body class="bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white min-h-screen flex flex-col transition">
<div class="max-w-7xl mx-auto py-6 px-4 flex-grow">

  <!-- Header -->
  <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-8 gap-4">
    <h1 class="text-2xl sm:text-3xl font-bold">🎮 Import Games</h1>
    <div class="flex gap-2 w-full sm:w-auto">
      <a href="dashboard" class="flex-1 sm:flex-none bg-blue-600 hover:bg-blue-500 px-5 py-2 rounded-lg shadow text-center">
        ⬅ Dashboard
      </a>
      <button id="toggleTheme" class="bg-gray-700 hover:bg-gray-600 px-5 py-2 rounded-lg shadow w-full sm:w-auto">
        🌙 / ☀️
      </button>
    </div>
  </div>

  <?php if (empty($provider)): ?>
    <!-- Pilih Provider -->
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4">
      <?php foreach ($providerUrls as $p => $url): ?>
        <a href="?provider=<?php echo $p; ?>"
           class="bg-gray-200 dark:bg-gray-800 hover:bg-gray-300 dark:hover:bg-gray-700 p-4 sm:p-6 rounded-xl shadow-lg text-center transition flex flex-col justify-center">
          <div class="text-base sm:text-lg font-semibold uppercase"><?php echo $p; ?></div>
          <div class="text-xs sm:text-sm text-gray-600 dark:text-gray-400 mt-1">Klik untuk import</div>
        </a>
      <?php endforeach; ?>
    </div>

  <?php else: ?>
    <?php
    if (!isset($providerUrls[$provider])) {
        echo "<div class='bg-red-600 text-white p-4 rounded'>❌ Provider tidak dikenal!</div>";
    } else {
        $url = $providerUrls[$provider];
        $outputFile = __DIR__ . "/" . $providerFiles[$provider];

        $html = @file_get_contents($url);
        if (!$html) {
            echo "<div class='bg-red-600 text-white p-4 rounded'>⚠️ Tidak bisa ambil data dari $url</div>";
        } else {
            $dom = new DOMDocument();
            libxml_use_internal_errors(true);
            $dom->loadHTML($html);
            libxml_clear_errors();

            $xpath = new DOMXPath($dom);
            $gameNodes = $xpath->query("//div[contains(@class,'game-box')]");

            $games = [];
            foreach ($gameNodes as $node) {
                $imgNode   = $xpath->query(".//img", $node)->item(0);
                $titleNode = $xpath->query(".//div[contains(@class,'game-title')]", $node)->item(0);

                if ($imgNode && $titleNode) {
                    $src = $imgNode->getAttribute("data-src") ?: $imgNode->getAttribute("src");
                    $alt = trim($titleNode->nodeValue);

                    if (strpos($src, "files.sitestatic.net") !== false && !empty($alt)) {
                        $games[] = ["img" => $src, "alt" => $alt];
                    }
                }
            }

            if (!empty($games)) {
                file_put_contents($outputFile, json_encode($games, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
                ?>
                <!-- Notif sukses -->
                <div class="bg-green-600 text-white p-4 rounded mb-6">
                  ✅ Berhasil simpan <b><?php echo count($games); ?></b> game ke <b><?php echo basename($outputFile); ?></b>
                </div>

                <!-- Preview games -->
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4 mb-8">
                  <?php foreach ($games as $g): ?>
                    <div class="bg-gray-200 dark:bg-gray-800 rounded-lg overflow-hidden shadow-md hover:scale-105 transition flex flex-col">
                      <img src="<?php echo htmlspecialchars($g['img']); ?>" alt="<?php echo htmlspecialchars($g['alt']); ?>" class="w-full h-32 sm:h-40 object-cover">
                      <div class="p-2 text-center text-xs sm:text-sm truncate"><?php echo htmlspecialchars($g['alt']); ?></div>
                    </div>
                  <?php endforeach; ?>
                </div>

                <!-- Tombol kembali ke provider -->
                <div class="flex justify-center">
                  <a href="import_games" class="bg-purple-600 hover:bg-purple-500 px-6 py-3 rounded-lg shadow text-white text-center">
                    ⬅ Kembali ke Pilihan Provider
                  </a>
                </div>
                <?php
            } else {
                echo "<div class='bg-yellow-500 text-black p-4 rounded'>⚠️ Tidak ada data game ditemukan!</div>";
            }
        }
    }
    ?>
  <?php endif; ?>

</div>

<!-- Loader -->
<div id="loader" class="fixed inset-0 bg-black bg-opacity-75 hidden items-center justify-center z-50">
  <div class="flex flex-col items-center">
    <svg class="animate-spin h-12 w-12 text-blue-500 mb-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
      <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
      <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
    </svg>
    <p class="text-white text-base sm:text-lg">Sedang memproses, harap tunggu...</p>
  </div>
</div>

<script>
// loader saat klik provider
document.querySelectorAll("a[href*='?provider=']").forEach(link => {
  link.addEventListener("click", () => {
    document.getElementById("loader").classList.remove("hidden");
    document.getElementById("loader").classList.add("flex");
  });
});

// dark/light toggle
document.getElementById("toggleTheme").addEventListener("click", () => {
  document.documentElement.classList.toggle("dark");
});
</script>
</body>
</html>
