<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/seo.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true);

// Simpan data
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["page"])) {
    $page = trim($_POST["page"]);
    if (!empty($page)) {
        $data[$page] = [
            "title" => $_POST["title"] ?? "",
            "description" => $_POST["description"] ?? "",
            "canonical" => $_POST["canonical"] ?? "",
            "keywords" => $_POST["keywords"] ?? "",
            "amphtml" => $_POST["amphtml"] ?? "",
            "favicon" => $_POST["favicon"] ?? "",
            "robots" => $_POST["robots"] ?? "",
            "googlebot" => $_POST["googlebot"] ?? "",
            "author" => $_POST["author"] ?? "",
            "publisher" => $_POST["publisher"] ?? "",
            "og_url" => $_POST["og_url"] ?? "",
            "og_site_name" => $_POST["og_site_name"] ?? "",
            "og_image_alt" => $_POST["og_image_alt"] ?? "",
            "google_site_verification" => $_POST["google_site_verification"] ?? ""
        ];
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        // Redirect supaya tidak ada confirm resubmission
        $msg = "✅ Data untuk halaman '$page' berhasil disimpan!";
        header("Location: seo_edit?msg=" . urlencode($msg));
        exit;
    }
}

// Hapus data
if (isset($_GET["delete"])) {
    $delPage = $_GET["delete"];
    if (isset($data[$delPage])) {
        unset($data[$delPage]);
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        $msg = "🗑 Data untuk halaman '$delPage' berhasil dihapus!";
    }
    header("Location: seo_edit?msg=" . urlencode($msg));
    exit;
}

// Edit data
$editPage = $_GET["page"] ?? "";
$current = $editPage && isset($data[$editPage]) ? $data[$editPage] : [
    "title" => "",
    "description" => "",
    "canonical" => "",
    "keywords" => "",
    "amphtml" => "",
    "favicon" => "",
    "robots" => "",
    "googlebot" => "",
    "author" => "",
    "publisher" => "",
    "og_url" => "",
    "og_site_name" => "",
    "og_image_alt" => "",
    "google_site_verification" => ""
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola SEO</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4">Kelola SEO</h2>

    <!-- Daftar SEO -->
    <div class="bg-white p-4 rounded shadow mb-6 overflow-x-auto">
        <h3 class="text-lg font-semibold mb-3">📑 Daftar Halaman SEO</h3>
        <table class="min-w-full text-sm border">
            <thead class="bg-gray-200">
                <tr>
                    <th class="border px-3 py-2">Halaman</th>
                    <th class="border px-3 py-2">Title</th>
                    <th class="border px-3 py-2">Description</th>
                    <th class="border px-3 py-2">Canonical</th>
                    <th class="border px-3 py-2">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $pageName => $values): ?>
                <tr class="odd:bg-white even:bg-gray-50">
                    <td class="border px-3 py-2"><?php echo htmlspecialchars($pageName); ?></td>
                    <td class="border px-3 py-2"><?php echo htmlspecialchars($values["title"] ?? ""); ?></td>
                    <td class="border px-3 py-2"><?php echo htmlspecialchars(substr($values["description"] ?? "",0,50)); ?>...</td>
                    <td class="border px-3 py-2"><?php echo htmlspecialchars($values["canonical"] ?? ""); ?></td>
                    <td class="border px-3 py-2 text-center space-x-2">
                        <a href="?page=<?php echo urlencode($pageName); ?>" class="text-blue-600 hover:underline">✏️ Edit</a>
                        <a href="javascript:void(0);" onclick="confirmDelete('<?php echo urlencode($pageName); ?>')" class="text-red-600 hover:underline">🗑 Hapus</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Form Tab -->
    <div class="bg-white p-4 rounded shadow mb-6">
        <h3 class="text-lg font-semibold mb-3">
            <?php echo $editPage ? "✏️ Edit Halaman: " . htmlspecialchars($editPage) : "➕ Tambah Halaman Baru"; ?>
        </h3>

        <!-- Tabs -->
        <div class="flex space-x-2 mb-4 overflow-x-auto text-sm">
            <button class="tab-btn px-3 py-1 rounded bg-blue-600 text-white" data-tab="basic">Basic</button>
            <button class="tab-btn px-3 py-1 rounded bg-gray-200" data-tab="meta">Meta</button>
            <button class="tab-btn px-3 py-1 rounded bg-gray-200" data-tab="og">OG</button>
            <button class="tab-btn px-3 py-1 rounded bg-gray-200" data-tab="lainnya">Lainnya</button>
        </div>

        <form method="post" class="space-y-3">
            <div>
                <label class="font-medium">Nama Halaman</label>
                <input type="text" name="page" value="<?php echo htmlspecialchars($editPage); ?>" required
                       placeholder="contoh: index atau habanero-index"
                       class="w-full p-2 border rounded">
            </div>

            <!-- Basic -->
            <div id="tab-basic" class="tab-content space-y-3">
                <div>
                    <label class="font-medium">Title</label>
                    <input type="text" id="title" name="title" value="<?php echo htmlspecialchars($current["title"]); ?>" required
                    placeholder="contoh: nama brand - bla bla bla" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="font-medium">Description</label>
                    <textarea id="description" name="description" required
                    placeholder="contoh: nama brand - bla bla bla" class="w-full p-2 border rounded"><?php echo htmlspecialchars($current["description"]); ?></textarea>
                </div>
                <div>
                    <label class="font-medium">Canonical</label>
                    <input type="text" id="canonical" name="canonical" value="<?php echo htmlspecialchars($current["canonical"]); ?>" required
                    placeholder="contoh: https://namadomain.com" class="w-full p-2 border rounded">
                </div>
                <div>
                    <label class="font-medium">Keywords</label>
                    <input type="text" name="keywords" value="<?php echo htmlspecialchars($current["keywords"]); ?>" required
                    placeholder="contoh: namabrand, namabrand slot, dll" class="w-full p-2 border rounded">
                </div>
            </div>

            <!-- Meta -->
            <div id="tab-meta" class="tab-content hidden space-y-3">
                <label class="font-medium">AMP HTML</label>
                <input type="text" name="amphtml" value="<?php echo htmlspecialchars($current["amphtml"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">Favicon</label>
                <input type="text" name="favicon" value="<?php echo htmlspecialchars($current["favicon"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">Robots</label>
                <input type="text" name="robots" value="<?php echo htmlspecialchars($current["robots"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">Googlebot</label>
                <input type="text" name="googlebot" value="<?php echo htmlspecialchars($current["googlebot"]); ?>" class="w-full p-2 border rounded">
            </div>

            <!-- OG -->
            <div id="tab-og" class="tab-content hidden space-y-3">
                <label class="font-medium">Author</label>
                <input type="text" name="author" value="<?php echo htmlspecialchars($current["author"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">Publisher</label>
                <input type="text" name="publisher" value="<?php echo htmlspecialchars($current["publisher"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">OG URL</label>
                <input type="text" name="og_url" value="<?php echo htmlspecialchars($current["og_url"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">OG Site Name</label>
                <input type="text" name="og_site_name" value="<?php echo htmlspecialchars($current["og_site_name"]); ?>" class="w-full p-2 border rounded">
                <label class="font-medium">OG Image Alt</label>
                <input type="text" name="og_image_alt" value="<?php echo htmlspecialchars($current["og_image_alt"]); ?>" class="w-full p-2 border rounded">
            </div>

            <!-- Lainnya -->
            <div id="tab-lainnya" class="tab-content hidden space-y-3">
                <label class="font-medium">Google Site Verification</label>
                <input type="text" name="google_site_verification" value="<?php echo htmlspecialchars($current["google_site_verification"]); ?>" class="w-full p-2 border rounded">
            </div>

            <div class="flex items-center space-x-3 mt-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded">💾 Simpan</button>
                <?php if ($editPage): ?>
                    <a href="seo_edit" class="px-4 py-2 bg-gray-400 text-black rounded">❌ Cancel</a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Preview -->
    <div class="bg-white p-4 rounded shadow">
        <h3 class="text-lg font-semibold mb-3">🔍 Preview Snippet Google (Live)</h3>
        <div id="preview-title" class="text-blue-700 text-lg"><?php echo htmlspecialchars($current["title"]); ?></div>
        <div id="preview-url" class="text-green-600"><?php echo htmlspecialchars($current["canonical"]); ?></div>
        <div id="preview-desc" class="text-gray-600 text-sm"><?php echo htmlspecialchars($current["description"]); ?></div>
    </div>

    <div class="mt-6">
        <a href="dashboard" class="text-blue-600 hover:underline">⬅ Kembali ke Dashboard</a>
    </div>

    <script>
        // Tabs
        const tabs = document.querySelectorAll(".tab-btn");
        const contents = document.querySelectorAll(".tab-content");
        tabs.forEach(tab => {
            tab.addEventListener("click", () => {
                tabs.forEach(t => t.classList.remove("bg-blue-600","text-white"));
                tabs.forEach(t => t.classList.add("bg-gray-200"));
                tab.classList.add("bg-blue-600","text-white");
                tab.classList.remove("bg-gray-200");
                contents.forEach(c => c.classList.add("hidden"));
                document.getElementById("tab-" + tab.dataset.tab).classList.remove("hidden");
            });
        });

        // Live preview
        const titleInput = document.getElementById("title");
        const descInput = document.getElementById("description");
        const canonInput = document.getElementById("canonical");
        const previewTitle = document.getElementById("preview-title");
        const previewDesc = document.getElementById("preview-desc");
        const previewUrl = document.getElementById("preview-url");

        if (titleInput) titleInput.addEventListener("input", () => previewTitle.textContent = titleInput.value);
        if (descInput) descInput.addEventListener("input", () => previewDesc.textContent = descInput.value);
        if (canonInput) canonInput.addEventListener("input", () => previewUrl.textContent = canonInput.value);

        // SweetAlert delete confirm
        function confirmDelete(page) {
            Swal.fire({
                title: "Yakin hapus?",
                text: "Data SEO untuk halaman '" + page + "' akan dihapus permanen.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Ya, hapus!",
                cancelButtonText: "Batal"
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "?delete=" + page;
                }
            });
        }

        // Toast sukses
        <?php if (isset($_GET["msg"])): ?>
        Swal.fire({
            toast: true,
            position: "top-end",
            icon: "success",
            title: "<?php echo htmlspecialchars($_GET['msg']); ?>",
            showConfirmButton: false,
            timer: 3000
        });
        <?php endif; ?>
    </script>
</body>
</html>
